/*:
 * @target MZ
 * @plugindesc 二刀流時は上の武器の攻撃スキルを優先して“攻撃”に適用 v1.0
 * @author You
 * @help
 * 武器のメモ欄に <AttackSkill: 15> のように書くと、
 * その武器を装備中は「攻撃」コマンドがスキルID15になります。
 * 二刀流時は上の武器（装備スロット0）を最優先し、
 * なければ下の武器（装備スロット1）、それもなければ通常の攻撃になります。
 *
 * 日本語でも可：<攻撃スキル: 15>
 *
 * このプラグインにパラメータはありません。
 */

(() => {
  const _Game_Actor_attackSkillId = Game_Actor.prototype.attackSkillId;

  function attackSkillFromWeapon(w) {
    if (!w) return 0;
    // <AttackSkill: n> または <攻撃スキル: n>
    const meta = w.meta || {};
    const v1 = meta.AttackSkill;
    const v2 = meta["攻撃スキル"];
    const v = v1 ?? v2;
    if (v !== undefined && v !== null && v !== "") {
      const n = Number(v);
      return Number.isFinite(n) ? n : 0;
    }
    return 0;
  }

  Game_Actor.prototype.attackSkillId = function () {
    // 二刀流時は上(0)→下(1)の順で優先
    const equips = this.equips ? this.equips() : [];
    const w0 = equips[0];
    const w1 = equips[1];

    if (this.isDualWield && this.isDualWield()) {
      const s0 = attackSkillFromWeapon(w0);
      if (s0) return s0;
      const s1 = attackSkillFromWeapon(w1);
      if (s1) return s1;
    } else {
      const s = attackSkillFromWeapon(w0);
      if (s) return s;
    }
    // どれも指定がなければデフォルト動作
    return _Game_Actor_attackSkillId.call(this);
  };
})();
